function save_fitted_model(CDX, file_name, start_date_num, end_date_num)
% --------------------------------------------------------------------------------------------------
% Save the parameters of a fitted model to an external file in the directory 'fitted models'. Only
% save fitted prices/parameters between 'start_date_num' and 'end_date_num'
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% file_name                     ... name of file where parameters should be stored
% --------------------------------------------------------------------------------------------------
% sample call: save_fitted_model(cdx_new, 'fit 02-01-2006', datenum('02/01/2006'), datenum('02/01/2006'))
% --------------------------------------------------------------------------------------------------

% Delete everything except the parameters
params = rmfield(CDX, {'T' 'index_market_price' 'tranche_market_price_mid' 'tranche_market_upfront_mid' 'index_members' 'cut_offs'});
params.portfolio = rmfield(params.portfolio, {'T' 'market_price' 'rating' 'DTD' 'intensity_P' 'return1yr'});
if isfield(params.portfolio, 'bid_ask_spread')
    params.portfolio = rmfield(params.portfolio, 'bid_ask_spread');
end
if isfield(params.portfolio, 'debt')
    params.portfolio = rmfield(params.portfolio, 'debt');
end
if isfield(params.portfolio, 'mcap')
    params.portfolio = rmfield(params.portfolio, 'mcap');
end
if isfield(params.portfolio, 'assets')
    params.portfolio = rmfield(params.portfolio, 'assets');
end
if isfield(params.portfolio, 'share_price')
    params.portfolio = rmfield(params.portfolio, 'share_price');
end

% Cut down parameters to relevant time window (for CDX params)
for i=1:length(params.dates)
    % date range
    start_pos = find(params.dates{i} >= start_date_num, 1, 'first');
    end_pos = find(params.dates{i} <= end_date_num, 1, 'last');
    used_range = start_pos:end_pos;
    params.dates{i} = params.dates{i}(used_range);
    % model-implied prices
    if (isfield(params, 'tranche_model_price'))
        if (length(params.tranche_model_price) >= i)
            params.tranche_model_price{i} = params.tranche_model_price{i}(used_range,:);
            params.tranche_model_upfront{i} = params.tranche_model_upfront{i}(used_range,:);
        else
            params.dates{i} = []; 
        end
    end
    if ((i == 1) && isfield(params, 'y0'))
        params.y0 = params.y0(used_range);
    end
    if ((i == 1) && isfield(params, 'rmse'))
        params.rmse = params.rmse(used_range);
    end
    if ((i == 1) && isfield(params, 'liq_prem_tranches'))
        params.liq_prem_tranches = params.liq_prem_tranches(used_range);
    end
    if ((i == 1) && isfield(params, 'liq_prem_cds'))
        params.liq_prem_cds = params.liq_prem_cds(used_range);
    end
    if (isfield(params, 'PV01') & (length(params.PV01)>=i) & length(params.PV01{i})>0)
        params.PV01{i} = params.PV01{i}(used_range,:);
    end
end

% Cut down parameters to relevant time window (for AJD params of common factor)
AJD = params.AJD_common_factor;
for i=1:length(params.dates)
    % date range
    start_pos = find(AJD.dates >= start_date_num, 1, 'first');
    end_pos = find(AJD.dates <= end_date_num, 1, 'last');
    used_range = start_pos:end_pos;
    AJD.dates = AJD.dates(used_range);
    if (length(AJD.k) > 1)
        AJD.k = AJD.k(used_range);
    end
    if (length(AJD.theta) > 1)
        AJD.theta = AJD.theta(used_range);
    end
    if (length(AJD.sigma) > 1)
        AJD.sigma = AJD.sigma(used_range);
    end
    if (length(AJD.L) > 1)
        AJD.L = AJD.L(used_range);
    end
    if (length(AJD.mu) > 1)
        AJD.mu = AJD.mu(used_range);
    end
end
params.AJD_common_factor = AJD;

% Do same for portfolio params
counter = 0;
for j=1:length(params.portfolio)
    cds = params.portfolio(j);  
    counter = counter+1;
    for i=1:length(cds.dates)
        % Determine relevant date range
        start_pos = find(cds.dates{i} >= start_date_num, 1, 'first');
        end_pos = find(cds.dates{i} <= end_date_num, 1, 'last');
        used_range = start_pos:end_pos;
        cds.dates{i} = cds.dates{i}(used_range);
        
        % Cut down data time series
        if (isfield(cds, 'model_price'))
            if (length(cds.model_price) >= i) & (length(cds.model_price{i}) > 0)
                cds.model_price{i} = cds.model_price{i}(used_range);
            end
        end
        if ((i == 1) & isfield(cds, 'x0'))
            cds.x0 = cds.x0(used_range);
        end
        if ((i == 1) & isfield(cds, 'DTD') & length(cds.DTD) > 0)
            cds.DTD = cds.DTD(used_range);
        end
        if ((i == 1) & isfield(cds, 'assets') & length(cds.assets) > 0)
            cds.assets = cds.assets(used_range);
        end
        if ((i == 1) & isfield(cds, 'return1yr') & length(cds.return1yr) > 0)
            cds.return1yr = cds.return1yr(used_range);
        end
        if ((i == 1) & isfield(cds, 'ai') & length(cds.ai) > 0)
            cds.ai = cds.ai(used_range);
        end
        if ((i == 1) & isfield(cds, 'bi') & length(cds.bi) > 0)
            cds.bi = cds.bi(used_range);
        end
        if ((i == 1) & isfield(cds, 'ai_P') & length(cds.ai_P) > 0)
            cds.ai_P = cds.ai_P(used_range);
        end
        if ((i == 1) & isfield(cds, 'bi_P') & length(cds.bi_P) > 0)
            cds.bi_P = cds.bi_P(used_range);
        end
        
        % Cut down AJD parameter time series
        if (i == 1)
            AJD = cds.AJD;
            AJD.dates = AJD.dates(used_range);
            if (length(AJD.k) > 1)
                AJD.k = AJD.k(used_range);
            end
            if (length(AJD.theta) > 1)
                AJD.theta = AJD.theta(used_range);
            end
            if (length(AJD.sigma) > 1)
                AJD.sigma = AJD.sigma(used_range);
            end
            if (length(AJD.L) > 1)
                AJD.L = AJD.L(used_range);
            end
            if (length(AJD.mu) > 1)
                AJD.mu = AJD.mu(used_range);
            end
            cds.AJD = AJD;
        end
    end
       
    if (counter==1)
        new_portfolio = cds;
    else
        new_portfolio(counter) = cds;
    end
end
params.portfolio = new_portfolio;

% Save everything in external file
file_name = ['fitted models/' file_name];
save(file_name, 'params');

